package app.firezone.synk.network.Fragments;



import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;

import androidx.fragment.app.Fragment;

import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;

import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.FirebaseDatabase;
import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.Fragment1Binding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.PaymentModel;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;
import app.firezone.synk.network.model.UserResponse;
import app.firezone.synk.network.model.WithdrawModel;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;


public class Fragment1 extends Fragment {

    Fragment1Binding binding;

    FirebaseDatabase database;

    private MyApi myApi;

    long userId;
    String email, username, phoneno;

    Dialog dialog;

    long minWithdraw, availWithdraw, inputUserCoins;

    FirebaseUser auth;
    DatabaseReference dr;

    @SuppressLint("MissingInflatedId")
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        binding = Fragment1Binding.inflate(inflater, container, false);
        View root = binding.getRoot();

        myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        database = FirebaseDatabase.getInstance();
        auth= FirebaseAuth.getInstance().getCurrentUser();

        userId = SharedPrefManager.getInstance(getContext()).getUserId(); // Get userId from SharedPreferences
        if (userId <= 0) {
            Toast.makeText(getContext(), "Invalid user ID", Toast.LENGTH_SHORT).show();
        }
        loadUserData();

        setMinimumWithdrawal();


        dialog = new Dialog(getContext());
        dialog.setContentView(R.layout.loading_dialog);


        if (dialog.getWindow() !=null){

            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();

        dialog.setCancelable(false);

        if (availWithdraw <= minWithdraw){
            binding.withdrawUpiBtn.setBackgroundResource(R.drawable.btn_true);
        }else {

            Toast.makeText(getContext(), "Minimum Withdraw "+minWithdraw+ "rs", Toast.LENGTH_SHORT).show();
            binding.withdrawUpiBtn.setBackgroundResource(R.drawable.btn_false);
            binding.withdrawUpiBtn.setClickable(false);

        }

        binding.withdrawUpiBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String amountStr = binding.withDrawUpi.getText().toString().trim();

                if (TextUtils.isEmpty(amountStr)) {
                    Toast.makeText(getContext(), "Enter Amount", Toast.LENGTH_SHORT).show();
                    return;
                }

                try {
                    long amount = Long.parseLong(amountStr);

                    if (amount < minWithdraw) {
                        binding.withDrawUpi.setError("Withdraw above " + minWithdraw + " rs");
                    } else if (amount > availWithdraw) {
                        Toast.makeText(getContext(), "Not Enough Money", Toast.LENGTH_SHORT).show();
                    } else {
                        inputUserCoins = amount;
                        withdrawMoney();
                    }
                } catch (NumberFormatException e) {
                    binding.withDrawUpi.setError("Please enter a valid number");
                }


            }
        });









        return root;
    }

    private void loadUserData() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
        Call<ApiResponse> call = myApi.fetchProfileData(userId);

        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                dialog.dismiss();
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();

                    long totalWinBal  = model.getWinBalance();
                    long totalDepoBal  = model.getDepoBalance();

                    availWithdraw = totalWinBal;

                    email = model.getEmail();
                    username = model.getName();
                    phoneno = model.getPhoneno();

                    binding.totalBalances.setText(String.valueOf(totalWinBal));
                    binding.name.setText(model.getName());

                    Picasso.get()
                            .load(model.getProfile())
                            .placeholder(R.drawable.new_users)
                            .into(binding.imageView15);
                } else {
                    Toast.makeText(getContext(), "Failed to fetch user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {
                dialog.dismiss();
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void withdrawMoney() {

        AlertDialog.Builder builder = new AlertDialog.Builder(getContext());
        View mView = getLayoutInflater().inflate(R.layout.upi_layout, null);

        final EditText userUpiId = (EditText) mView.findViewById(R.id.upiIdEdt);
        final TextView amount = (TextView) mView.findViewById(R.id.amount);
        Button withdrawBtn = (Button) mView.findViewById(R.id.upiWithdrawBtn);


        amount.setText(binding.withDrawUpi.getText().toString());

        builder.setView(mView);
        AlertDialog alertDialogs = builder.create();

        withdrawBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                String upiId = userUpiId.getText().toString();

                if (TextUtils.isEmpty(upiId)){
                    Toast.makeText(getContext(), "Enter Your UPI Id.", Toast.LENGTH_SHORT).show();
                    userUpiId.setError("Enter UPI Id");
                }else {

                    String withdrawCoins =  binding.withDrawUpi.getText().toString();
                    String upiIds =  userUpiId.getText().toString();
                    String status  =  "Pending";
                    String method  =  "UPI";

                    Calendar calForDate= Calendar.getInstance();
                    SimpleDateFormat currentDate= new SimpleDateFormat("dd-MM-yy");
                    String date= currentDate.format(calForDate.getTime());

                    // Example data to store
                    myApi = APIClient.getApiClient(getContext()).create(MyApi.class);
                    Call<WithdrawModel> call = myApi.storeWithdraw(
                            String.valueOf(userId),
                            withdrawCoins,
                            username,
                            email,
                            phoneno,
                            date,
                            upiIds,
                            "N/A",
                            "N/A",
                            "N/A",
                            "N/A",
                            status,
                            method
                    );

                    call.enqueue(new Callback<WithdrawModel>() {
                        @Override
                        public void onResponse(Call<WithdrawModel> call, Response<WithdrawModel> response) {
                            if (response.isSuccessful() && response.body() != null) {
                                Toast.makeText(getContext(), "Withdraw request submitted successfully!", Toast.LENGTH_SHORT).show();
                                alertDialogs.dismiss();
                                binding.withDrawUpi.setText("");
                                deductedMoney();
                            } else {
                                Toast.makeText(getContext(), "Failed: " + response.message(), Toast.LENGTH_LONG).show();
                            }
                        }

                        @Override
                        public void onFailure(Call<WithdrawModel> call, Throwable t) {
                            Toast.makeText(getContext(), "Error: " + t.getMessage(), Toast.LENGTH_LONG).show();
                        }
                    });

                }
            }
        });

        alertDialogs.show();

    }

    private void setMinimumWithdrawal() {

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        Call<ArrayList<PaymentModel>> call = myApi.fetchPaymentSetting();

        call.enqueue(new Callback<ArrayList<PaymentModel>>() {
            @Override
            public void onResponse(Call<ArrayList<PaymentModel>> call, Response<ArrayList<PaymentModel>> response) {
                dialog.dismiss(); // Dismiss the dialog

                if (response.isSuccessful() && response.body() != null && !response.body().isEmpty()) {
                    PaymentModel model = response.body().get(0); // Assuming you need the first payment setting

                    minWithdraw = model.getMinWithdraw();
                } else {
                    Toast.makeText(getContext(), "Failed to fetch payment settings", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ArrayList<PaymentModel>> call, Throwable throwable) {
                dialog.dismiss(); // Dismiss the dialog on failure
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private  void deductedMoney() {
        long finalCoins =  availWithdraw - inputUserCoins;

        Map<String, Object> updateData = new HashMap<>();
        updateData.put("winBalance",finalCoins);

        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        Call<UserResponse> call = myApi.updateUser(userId, updateData);
        call.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        saveUsersTransactionDetails();
                        Toast.makeText(getContext(), "Amount Debited..", Toast.LENGTH_SHORT).show();
                        loadUserData(); // <--- NEW: update UI & availWithdraw
                    } else {
                        Toast.makeText(getContext(), response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(getContext(), "Failed to update balance", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void saveUsersTransactionDetails() {
        // Get user details
        long userIdLong = SharedPrefManager.getInstance(getContext()).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(inputUserCoins);

        // Initialize API Client
        MyApi myApi = APIClient.getApiClient(getContext()).create(MyApi.class);

        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                "Withdraw", // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "Wallet", // method
                "Pending" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Toast.makeText(getContext(), "Transaction Recorded Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(getContext(), "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(getContext(), "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }



}